/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import com.buuz135.industrial.item.IFCustomItem;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.TagUtil;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class MobImprisonmentToolItem
extends IFCustomItem {
    public MobImprisonmentToolItem(CreativeModeTab group) {
        super("mob_imprisonment_tool", group, new Item.Properties().m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack;
        Level worldIn;
        Direction facing;
        BlockPos pos;
        Player player = context.m_43723_();
        if (!this.release(player, pos = context.m_8083_(), facing = context.m_43719_(), worldIn = context.m_43725_(), stack = context.m_43722_())) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        if (!this.capture(stack, target)) {
            return InteractionResult.FAIL;
        }
        playerIn.m_6674_(hand);
        playerIn.m_21008_(hand, stack);
        return InteractionResult.SUCCESS;
    }

    public boolean capture(ItemStack stack, LivingEntity target) {
        if (target.m_20193_().f_46443_) {
            return false;
        }
        if (target instanceof Player || !target.m_6072_() || !target.m_6084_()) {
            return false;
        }
        if (this.containsEntity(stack)) {
            return false;
        }
        if (this.isBlacklisted(target.m_6095_())) {
            return false;
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("entity", EntityType.m_20613_((EntityType)target.m_6095_()).toString());
        target.m_20240_(nbt);
        stack.m_41751_(nbt);
        target.m_142687_(Entity.RemovalReason.KILLED);
        return true;
    }

    public boolean release(Player player, BlockPos pos, Direction facing, Level worldIn, ItemStack stack) {
        if (player.m_20193_().f_46443_) {
            return false;
        }
        if (!this.containsEntity(stack)) {
            return false;
        }
        Entity entity = this.getEntityFromStack(stack, worldIn, true, false);
        BlockPos blockPos = pos.m_142300_(facing);
        entity.m_19890_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
        stack.m_41751_(null);
        worldIn.m_7967_(entity);
        return true;
    }

    public boolean isBlacklisted(EntityType<?> entity) {
        return TagUtil.hasTag((IForgeRegistry)ForgeRegistries.ENTITIES, entity, IndustrialTags.EntityTypes.MOB_IMPRISONMENT_TOOL_BLACKLIST);
    }

    public boolean containsEntity(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41782_() && stack.m_41783_().m_128441_("entity");
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        if (this.containsEntity(stack)) {
            tooltip.add((Component)new TextComponent("Mob: " + this.getID(stack)));
            tooltip.add((Component)new TextComponent("Health: " + stack.m_41783_().m_128459_("Health")));
        }
    }

    @Nullable
    public Entity getEntityFromStack(ItemStack stack, Level world, boolean withInfo, boolean applyDuplicatorFilter) {
        EntityType type;
        if (!(!stack.m_41782_() || (type = (EntityType)EntityType.m_20632_((String)stack.m_41783_().m_128461_("entity")).orElse(null)) == null || applyDuplicatorFilter && ForgeRegistries.ENTITIES.tags().getTag(IndustrialTags.EntityTypes.MOB_DUPLICATOR_BLACKLIST).contains((Object)type))) {
            Entity entity = type.m_20615_(world);
            if (withInfo) {
                entity.m_20258_(stack.m_41783_());
            } else if (!type.m_20654_()) {
                return null;
            }
            return entity;
        }
        return null;
    }

    public String getID(ItemStack stack) {
        return stack.m_41783_().m_128461_("entity");
    }

    public Component m_7626_(ItemStack stack) {
        if (!this.containsEntity(stack)) {
            return new TranslatableComponent(super.m_5671_(stack));
        }
        return new TranslatableComponent(super.m_5671_(stack)).m_130946_(" (" + this.getID(stack) + ")");
    }

    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).m_126130_(" P ").m_126130_("PGP").m_126130_(" P ").m_206416_(Character.valueOf('P'), IndustrialTags.Items.PLASTIC).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42586_).m_176498_(consumer);
    }
}

